package gov.va.genisis2;

import static org.springframework.test.web.servlet.setup.MockMvcBuilders.standaloneSetup;
import gov.va.genisis2.bo.ActivitiService;
import gov.va.genisis2.bo.BusinessService;
import gov.va.genisis2.configuration.GenisisPropertiesUtil;
import gov.va.genisis2.controller.Genisis2Controller;
import gov.va.genisis2.converter.RefreshHistoryConverter;
import gov.va.genisis2.converter.RequestConverter;
import gov.va.genisis2.converter.RequestTypeConverter;
import gov.va.genisis2.converter.RoleTypeConverter;
import gov.va.genisis2.converter.SourceConverter;
import gov.va.genisis2.converter.StudyApprovalConverter;
import gov.va.genisis2.converter.UserApproverConverter;
import gov.va.genisis2.converter.UserConverter;
import gov.va.genisis2.converter.UserCountConverter;
import gov.va.genisis2.converter.UserRoleTypeConverter;
import gov.va.genisis2.converter.UserTypeConverter;
import gov.va.genisis2.dao.impl.CommentHistoryDao;
import gov.va.genisis2.dao.impl.LookUpDao;
import gov.va.genisis2.dao.impl.RequestDao;
import gov.va.genisis2.dao.impl.StudyApprovalDao;
import gov.va.genisis2.dao.impl.UserManagementDao;
import gov.va.genisis2.service.impl.CommentHistoryService;
import gov.va.genisis2.service.impl.LookUpService;
import gov.va.genisis2.service.impl.RequestService;
import gov.va.genisis2.service.impl.StudyApprovalService;
import gov.va.genisis2.service.impl.UserManagementService;

import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.validation.BindingResult;

/**
 * The Class AbstractMockMvcTests.
 *
 * @author1 Janet Lopez
 * @author2 Getaneh Kassahun
 * 
 *          The Class AbstractMockMvcTests.
 * 
 *          Description: In this Abstract Class, data and methods are defined to
 *          create an instance of Genisis2Controller and pass in an instance of
 *          the mocked interface by using the Object property to basically
 *          injecting the dependency by hand.
 */

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration("file:src/test/resources/applicationContext.xml")
public class AbstractMockMvcTests {

	/** The newline. */
	protected static String newline = "<br />";

	/** The sessionFactory. */
	@Autowired
	protected SessionFactory sessionFactory;

	/** The mock mvc. */
	protected MockMvc mockMvc;

	/** The genisis 2 controller. */
	@InjectMocks
	protected Genisis2Controller genisis2Controller;

	/** The mock comment history dao. */
	@Mock
	protected CommentHistoryDao mockCommentHistoryDao;

	/** The mock look up dao. */
	@Mock
	protected LookUpDao mockLookUpDao;

	/** The mock request dao. */
	@Mock
	protected RequestDao mockRequestDao;

	/** The mock study approval dao. */
	@Mock
	protected StudyApprovalDao mockStudyApprovalDao;

	/** The mock user management dao. */
	@Mock
	protected UserManagementDao mockUserManagementDao;

	/** The result. */
	@Mock
	protected BindingResult result;

	/** The mock activiti service. */
	@Mock
	protected ActivitiService mockActivitiService;

	/** The mock business service. */
	@Mock
	protected BusinessService mockBusinessService;

	/** The mock comment history service. */
	@Mock
	protected CommentHistoryService mockCommentHistoryService;

	/** The mock look up service. */
	@Mock
	protected LookUpService mockLookUpService;

	/** The mock request service. */
	@Mock
	protected RequestService mockRequestService;

	/** The mock study approval service. */
	@Mock
	protected StudyApprovalService mockStudyApprovalService;

	/** The mock user management service. */
	@Mock
	protected UserManagementService mockUserManagementService;

	/** The mockStudyApprovalConverter. */
	@Mock
	protected StudyApprovalConverter mockStudyApprovalConverter;

	/** The mockUserConverter. */
	@Mock
	protected UserConverter mockUserConverter;

	/** The mockUserRoleTypeConverter. */
	@Mock
	protected UserRoleTypeConverter mockUserRoleTypeConverter;

	/** The mockUserApproverConverter. */
	@Mock
	protected UserApproverConverter mockUserApproverConverter;

	/** The mockUserCountConverter. */
	@Mock
	protected UserCountConverter mockUserCountConverter;

	/** The mockUserRefreshHistoryConverter. */
	@Mock
	protected RefreshHistoryConverter mockUserRefreshHistoryConverter;

	/** The mockRoleTypeConverter. */
	@Mock
	protected RoleTypeConverter mockRoleTypeConverter;

	/** The mockUserTypeConverter. */
	@Mock
	protected UserTypeConverter mockUserTypeConverter;
	
	/** The mockSourceConverter. */
	@Mock
	protected SourceConverter mockSourceConverter;
	
	/** The mockRequestTypeConverter. */
	@Mock
	protected RequestTypeConverter mockRequestTypeConverter;
	
	/** The mockRequestConverter. */
	@Mock
	protected RequestConverter mockRequestConverter;

	/** The mockGenisisPropertiesUtil. */
	@Mock
	protected GenisisPropertiesUtil mockGenisisPropertiesUtil;

	/** The mock comment history dao. */
	@Mock
	private SessionFactory mockSessionFactory;

	/**
	 * Gets the mock mvc.
	 *
	 * @return the mock mvc
	 */
	public MockMvc getMockMvc() {
		return this.mockMvc;
	}

	/**
	 * Gets the mock comment history dao.
	 *
	 * @return the mock comment history dao
	 */
	public CommentHistoryDao getMockCommentHistoryDao() {
		return mockCommentHistoryDao;
	}

	/**
	 * Gets the mock look up dao.
	 *
	 * @return the mock look up dao
	 */
	public LookUpDao getMockLookUpDao() {
		return mockLookUpDao;

	}

	/**
	 * Gets the mock request dao.
	 *
	 * @return the mock request dao
	 */
	public RequestDao getMockRequestDao() {
		return mockRequestDao;
	}

	/**
	 * Gets the mock study approval dao.
	 *
	 * @return the mock study approval dao
	 */
	public StudyApprovalDao getMockStudyApprovalDao() {
		return mockStudyApprovalDao;
	}

	/**
	 * Gets the mock user management dao.
	 *
	 * @return the mock user management dao
	 */
	public UserManagementDao getMockUserManagementDao() {
		return mockUserManagementDao;
	}

	/**
	 * Gets the genisis 2 controller.
	 *
	 * @return the genisis 2 controller
	 */
	public Genisis2Controller getGenisis2Controller() {
		return genisis2Controller;
	}

	/**
	 * Gets the activiti service.
	 *
	 * @return the activiti service
	 */
	public ActivitiService getMockActivitiService() {
		return this.mockActivitiService;
	}

	/**
	 * Gets the business service.
	 *
	 * @return the business service
	 */
	public BusinessService getMockBusinessService() {
		return this.mockBusinessService;
	}

	/**
	 * Gets the comment history service.
	 *
	 * @return the study approval service
	 */
	public CommentHistoryService getMockCommentHistoryService() {
		return this.mockCommentHistoryService;
	}

	/**
	 * Gets the mock look up service.
	 *
	 * @return the mock look up service
	 */
	public LookUpService getMockLookUpService() {
		return this.mockLookUpService;
	}

	/**
	 * Gets the request service.
	 *
	 * @return the request service
	 */
	public RequestService getMockRequestService() {
		return this.mockRequestService;
	}

	/**
	 * Gets the study approval service.
	 *
	 * @return the study approval service
	 */
	public StudyApprovalService getMockStudyApprovalService() {
		return this.mockStudyApprovalService;
	}

	/**
	 * Gets the user management service.
	 *
	 * @return the user management service
	 */
	public UserManagementService getMockUserManagementService() {
		return this.mockUserManagementService;
	}

	/**
	 * Setup.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Before
	public void setup() throws Exception {
		MockitoAnnotations.initMocks(this);
		this.mockMvc = standaloneSetup(genisis2Controller)
				.setMessageConverters(new MappingJackson2HttpMessageConverter()).build();
	}

	/**
	 * @return the newline
	 */
	public static String getNewline() {
		return newline;
	}

	/**
	 * @return the sessionFactory
	 */
	public SessionFactory getSessionFactory() {
		return sessionFactory;
	}

	/**
	 * @return the result
	 */
	public BindingResult getResult() {
		return result;
	}

	/**
	 * @return the mockStudyApprovalConverter
	 */
	public StudyApprovalConverter getMockStudyApprovalConverter() {
		return mockStudyApprovalConverter;
	}

	/**
	 * @return the mockUserConverter
	 */
	public UserConverter getMockUserConverter() {
		return mockUserConverter;
	}

	/**
	 * @return the mockUserRoleTypeConverter
	 */
	public UserRoleTypeConverter getMockUserRoleTypeConverter() {
		return mockUserRoleTypeConverter;
	}

	/**
	 * @return the mockUserApproverConverter
	 */
	public UserApproverConverter getMockUserApproverConverter() {
		return mockUserApproverConverter;
	}

	/**
	 * @return the mockUserCountConverter
	 */
	public UserCountConverter getMockUserCountConverter() {
		return mockUserCountConverter;
	}

	/**
	 * @return the mockUserRefreshHistoryConverter
	 */
	public RefreshHistoryConverter getMockUserRefreshHistoryConverter() {
		return mockUserRefreshHistoryConverter;
	}

	/**
	 * @return the mockRoleTypeConverter
	 */
	public RoleTypeConverter getMockRoleTypeConverter() {
		return mockRoleTypeConverter;
	}

	/**
	 * @return the mockUserTypeConverter
	 */
	public UserTypeConverter getMockUserTypeConverter() {
		return mockUserTypeConverter;
	}

	/**
	 * @return the mockSessionFactory
	 */
	public SessionFactory getMockSessionFactory() {
		return mockSessionFactory;
	}
	
	/**
	 * @return the mockSourceConverter
	 */
	public SourceConverter getMockSourceConverter() {
		return mockSourceConverter;
	}
	
	/**
	 * @return the mockGenisisPropertiesUtil
	 */
	public GenisisPropertiesUtil getMockGenisisPropertiesUtil() {
		return mockGenisisPropertiesUtil;
	}

	/**
	 * @return the mockRequestTypeConverter
	 */
	public RequestTypeConverter getMockRequestTypeConverter() {
		return mockRequestTypeConverter;
	}

	/**
	 * @return the mockRequestConverter
	 */
	public RequestConverter getMockRequestConverter() {
		return mockRequestConverter;
	}

	/**
	 * Teardown.
	 *
	 * @throws Exception
	 *             the exception
	 */

	@After
	public void teardown() throws Exception {
	}

}